#include "stdafx.h"
#include "audiosource_binary.h"
#include "debug.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

	//////////////////////
	// audio cue points //
	//////////////////////
/*
CUEPOINTS::CUEPOINTS()
{
	points = new CDynIntArray;
}

void CUEPOINTS::AddPoint(__int64 iTimecode, __int64 iPosition)
{
	AUDIO_CUEPOINT* p = new AUDIO_CUEPOINT;
	p->iTimecode = iTimecode;
	p->iStreamPosition = iPosition;

	points->Insert((int)p);
}

int CUEPOINTS::FindClosestPoint(__int64 iTimecode, __int64* piTimecode, __int64* piPosition)
{
	AUDIO_CUEPOINT* p[3];
	
	if (!points->GetCount()) {
		return -1;
	}

	if (!piTimecode && !piPosition) {
		return -1;
	}

	p[2] = (AUDIO_CUEPOINT*)points->At(points->GetCount()-1);
	if (p[2]->iTimecode<iTimecode) {
		if (piTimecode) *piTimecode = p[2]->iTimecode;
		if (piPosition) *piPosition = p[2]->iStreamPosition;
		return 1;
	}

	p[0] = (AUDIO_CUEPOINT*)points->At(0);
	if (p[0]->iTimecode>iTimecode) {
		return -1;
	}

	int  iMin, iMax, iMid;
	iMin = 0;
	iMax = points->GetCount()-1;

	while (iMax - iMin > 1) {
		iMid = (iMin + iMax) >> 1;
		p[1] = (AUDIO_CUEPOINT*)points->At(iMid);

		if (p[0]->iTimecode > iTimecode && p[1]->iTimecode < iTimecode) {
			p[2] = p[1];
			iMax = iMid;
		} else {
			p[0] = p[1];
			iMin = iMid;
		}
	}

	if (piTimecode) *piTimecode = p[0]->iTimecode;
	if (piPosition) *piPosition = p[0]->iStreamPosition;

	return 0;
}

void CUEPOINTS::Delete()
{
	for (int i=points->GetCount()-1;i>=0;i--) {
		delete ((AUDIO_CUEPOINT*)points->At(i));
	}

	points->DeleteAll();
	delete points;
}
*/

	///////////////////////////////////////////
	// audio source from binary input stream //
	///////////////////////////////////////////


AUDIOSOURCEFROMBINARY::AUDIOSOURCEFROMBINARY()
{
	source=NULL; 
	SetName(NULL); 
	dwResync_Range = 131072; 
	bEndReached = 0;
	unstretched_duration = 0;
	SetTimecodeScale(1000);
}


void AUDIOSOURCEFROMBINARY::ReInit()
{
	if (!GetSource())
		return;

	GetSource()->InvalidateCache();
	Seek(0);
}

int AUDIOSOURCEFROMBINARY::Seek(__int64 qwPos)
{
	GetSource()->Seek(qwPos);
	if (GetAvgBytesPerSec()) {
		SetCurrentTimecode(qwPos * 1000000000 / GetAvgBytesPerSec(), TIMECODE_UNSCALED);
	}
	if (!qwPos) SetCurrentTimecode(0);
	bEndReached = 0;
	return STREAM_OK;
}

int AUDIOSOURCEFROMBINARY::Open(STREAM* lpStream)
{
	 char	lpcName[256];

	 source=lpStream;
	 if (lpStream)
	 {
		 lpStream->GetName(lpcName);
		 SetName(lpcName);
	 }

	 return (lpStream)?AS_OK:AS_ERR; 
}


int AUDIOSOURCEFROMBINARY::Read(void* lpDest,DWORD dwMicroSecDesired,DWORD* lpdwMicrosecRead,
					  __int64* lpqwNanosecRead, __int64* lpiTimecode, ADVANCEDREAD_INFO* lpAARI)
{
	__int64	iNanosecRead, iCTC;
	
	if (lpiTimecode) *lpiTimecode = iCTC = GetCurrentTimecode();

	int	iRead = -1;
	
	if (!IsEndOfStream())
		iRead = doRead(lpDest,dwMicroSecDesired,lpdwMicrosecRead,&iNanosecRead);
	if (iRead <= 0) bEndReached = 1;

	if (lpqwNanosecRead) *lpqwNanosecRead = iNanosecRead;

	__int64 iLTC = -1000;
	
	IncCurrentTimecode(iNanosecRead);
	if (lpAARI) lpAARI->iNextTimecode = GetCurrentTimecode();

	if (IsEndOfStream())
		unstretched_duration = GetCurrentTimecode() - GetBias();

	return iRead;
}

__int64 AUDIOSOURCEFROMBINARY::GetUnstretchedDuration()
{
	if (GetMaxLength())
		return GetMaxLength();

	return unstretched_duration;
}

int AUDIOSOURCEFROMBINARY::doClose()
{ 
	source=NULL; 
	if (lpcName) {
		delete lpcName;
		lpcName = NULL;
	}

	return AS_OK; 
}

__int64 AUDIOSOURCEFROMBINARY::GetExactSize()
{
	return GetSource()->GetSize();
}

bool AUDIOSOURCEFROMBINARY::IsEndOfStream()
{
	return (/*GetMaxLength() <= GetCurrentTimecode()-GetBias() || */bEndReached || source->IsEndOfStream()); 
}

int AUDIOSOURCEFROMBINARY::GetAvgBytesPerSec()
{
	int i = source->GetAvgBytesPerSec();
	if (i)
		return i;

	__int64 duration = GetDuration() * GetTimecodeScale() / 1000000000;

	return (int)((double)GetSize()/(double)duration);

}

int AUDIOSOURCEFROMBINARY::GetChannelCount()
{
	 return GetSource()->GetChannels();
}

int AUDIOSOURCEFROMBINARY::GetFrequency()
{
	 return GetSource()->GetFrequency();
}

void AUDIOSOURCEFROMBINARY::SetResyncRange(DWORD dwRange)
{
	dwResync_Range = dwRange;
}

int AUDIOSOURCEFROMBINARY::GetResyncRange()
{ 
	return dwResync_Range; 
}

int AUDIOSOURCEFROMBINARY::GetOffset()
{
	return (GetSource())?GetSource()->GetOffset():0;
}

bool AUDIOSOURCEFROMBINARY::IsCBR()
{
	return false;
}

	//////////////////////////////
	// general CBR audio source //
	//////////////////////////////
/*
int CBRAUDIOSOURCE::doRead(void* lpDest,DWORD dwMicroSecDesired,DWORD* lpdwMicroSecRead,__int64* lpqwNanoSecRead)
{
	DWORD	dwBytes,dwAdd;

	if (GetGranularity==0) 
	{
		// variable Granularitt bei CBR-Audio nicht zulssig!
		*lpdwMicroSecRead=0;
		return 0;
	}
	dwBytes=(DWORD)((__int64)dwMicroSecDesired*(__int64)GetAvgBytesPerSec()/1000000);
	dwAdd=(dwBytes%GetGranularity())?1:0;
	dwBytes/=GetGranularity();
	dwBytes+=dwAdd;
	dwBytes*=GetGranularity();

	dwBytes=GetSource()->Read(lpDest,dwBytes);
	if (lpdwMicroSecRead) 
	{
		*lpdwMicroSecRead=(DWORD)round(1000000*d_div(dwBytes,GetAvgBytesPerSec(),"CBRAUDIOSOURCE::Read: GetAvgBytesPerSec()"));
	}
	if (lpqwNanoSecRead) 
	{
		*lpqwNanoSecRead=round(1000000000*d_div(dwBytes,GetAvgBytesPerSec(),"CBRAUDIOSOURCE::Read: GetAvgBytesPerSec()"));
	}

	return dwBytes;
}

int CBRAUDIOSOURCE::doClose()
{
	 return AUDIOSOURCE::doClose();
}

*/