// EnhancedListBox.cpp: Implementierungsdatei
//

#include "stdafx.h"
#include "AVIMux_GUI.h"
#include "EnhancedListBox.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CEnhancedListBox

CEnhancedListBox::CEnhancedListBox()
{
	EnableAutomation();
	bMButtonDown=false;
	ptMButtonDown.x=0;
	ptMButtonDown.y=0;
	bMovingAllowed=true;
	iItemMButtonDown=0;
}

CEnhancedListBox::~CEnhancedListBox()
{
}

void CEnhancedListBox::OnFinalRelease()
{
	// Nachdem die letzte Referenz auf ein Automatisierungsobjekt freigegeben wurde,
	// wird OnFinalRelease aufgerufen. Die Basisklasse lscht das Objekt
	// automatisch. Fgen Sie zustzlichen Bereinigungscode fr Ihr Objekt
	// hinzu, bevor Sie die Basisklasse aufrufen.

	CListBox::OnFinalRelease();
}


BEGIN_MESSAGE_MAP(CEnhancedListBox, CListBox)
	//{{AFX_MSG_MAP(CEnhancedListBox)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_WM_MBUTTONDOWN()
	ON_WM_MBUTTONUP()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(CEnhancedListBox, CListBox)
	//{{AFX_DISPATCH_MAP(CEnhancedListBox)
		// HINWEIS - Der Klassen-Assistent fgt hier Zuordnungsmakros ein und entfernt diese.
	//}}AFX_DISPATCH_MAP
END_DISPATCH_MAP()

// Hinweis: Wir stellen Untersttzung fr IID_IEnhancedListBox zur Verfgung, um typsicheres Binden
//  von VBA zu ermglichen. Diese IID muss mit der GUID bereinstimmen, die in der
//  Disp-Schnittstelle in der .ODL-Datei angegeben ist.

// {7566FCBE-39C6-441A-9D51-E627E440BBA2}
static const IID IID_IEnhancedListBox =
{ 0x7566fcbe, 0x39c6, 0x441a, { 0x9d, 0x51, 0xe6, 0x27, 0xe4, 0x40, 0xbb, 0xa2 } };

BEGIN_INTERFACE_MAP(CEnhancedListBox, CListBox)
	INTERFACE_PART(CEnhancedListBox, IID_IEnhancedListBox, Dispatch)
END_INTERFACE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen fr Nachrichten CEnhancedListBox 

void CEnhancedListBox::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Code fr die Behandlungsroutine fr Nachrichten hier einfgen und/oder Standard aufrufen
	if (nFlags&MK_SHIFT)
	{
		bMButtonDown=true;
	}
	else
	{
		CListBox::OnLButtonDown(nFlags, point);
	}
}

void CEnhancedListBox::ItemDown(void)
{
	CEnhancedListBox*	lpAAS=this;
	DWORD	dwSelCount,dwICount,dwItemData;
	DWORD*	lpdwSel;
	int		i,iIndex;
	char*	lpcText;

	dwSelCount=lpAAS->GetSelCount();
	dwICount=lpAAS->GetCount();
	if (dwSelCount)
	{
		lpdwSel=(DWORD*)malloc(4*dwSelCount);
		lpAAS->GetSelItems(dwSelCount,(int*)lpdwSel);
		for (i=dwSelCount-1;i>=0;i--)
		{
			if (lpdwSel[i]!=dwICount-1)
			{
				lpcText=(char*)malloc(lpAAS->GetTextLen(lpdwSel[i]));
				lpAAS->GetText(lpdwSel[i],lpcText);
				dwItemData=lpAAS->GetItemData(lpdwSel[i]);
				lpAAS->DeleteString(lpdwSel[i]);
				iIndex=lpAAS->InsertString(lpdwSel[i]+1,lpcText);
				lpAAS->SetItemData(iIndex,dwItemData);
				lpAAS->SetSel(iIndex,true);
			}
		}
	}
}

void CEnhancedListBox::ItemUp(void)
{
	DWORD	dwSelCount,dwICount;
	DWORD*	lpdwSel;
	DWORD	i,iIndex;
	char*	lpcText;
	DWORD	dwItemData;
	CEnhancedListBox*	lpAAS=this;

	dwSelCount=lpAAS->GetSelCount();
	dwICount=lpAAS->GetCount();
	if (dwSelCount)
	{
		lpdwSel=(DWORD*)malloc(4*dwSelCount);
		lpAAS->GetSelItems(dwSelCount,(int*)lpdwSel);
		for (i=0;i<dwSelCount;i++)
		{
			if (lpdwSel[i])
			{
				lpcText=(char*)malloc(lpAAS->GetTextLen(lpdwSel[i]));
				lpAAS->GetText(lpdwSel[i],lpcText);
				dwItemData=lpAAS->GetItemData(lpdwSel[i]);
				lpAAS->DeleteString(lpdwSel[i]);
				iIndex=lpAAS->InsertString(lpdwSel[i]-1,lpcText);
				lpAAS->SetItemData(iIndex,dwItemData);
				lpAAS->SetSel(iIndex,true);
				free(lpcText);
			}
		}
	}
}

void CEnhancedListBox::OnLButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Code fr die Behandlungsroutine fr Nachrichten hier einfgen und/oder Standard aufrufen
	bMButtonDown=false;
	CListBox::OnLButtonUp(nFlags, point);
}

void CEnhancedListBox::AllowMoving(bool bAllowMoving)
{
	bMovingAllowed=bAllowMoving;
}

void CEnhancedListBox::RedoNumbering()
{
}

void CEnhancedListBox::OnMouseMove(UINT nFlags, CPoint point) 
{
	// TODO: Code fr die Behandlungsroutine fr Nachrichten hier einfgen und/oder Standard aufrufen
	int	iOutside;

	if (bMButtonDown)
	{
		int	i=ItemFromPoint(point,iOutside);
		if (bMovingAllowed)
		{
			if (i>iItemMButtonDown)
			{
				ItemDown();
				RedoNumbering();
			}
			if (i<iItemMButtonDown)
			{
				ItemUp();
				RedoNumbering();
			}
			iItemMButtonDown=i;
		}
		else
		{
			CListBox::OnMouseMove(nFlags, ptMButtonDown);
		}
	}
	else
	{
		CListBox::OnMouseMove(nFlags, point);
	}
}

void CEnhancedListBox::OnMButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Code fr die Behandlungsroutine fr Nachrichten hier einfgen und/oder Standard aufrufen
	int 	iOutside;

	iItemMButtonDown=ItemFromPoint(point,iOutside);
	ptMButtonDown=point;
	bMButtonDown=true;
}

void CEnhancedListBox::OnMButtonUp(UINT nFlags, CPoint point) 
{
	// TODO: Code fr die Behandlungsroutine fr Nachrichten hier einfgen und/oder Standard aufrufen
	bMButtonDown=false;
		
}
